this.name = "Gas Giant Refueling";
this.author	= "Blake Deakins - a.k.a. Cmd. Cheyd";
this.description = "Allow players to fuel scoop from gas giant-textured worlds.";
this.version = "1.0.6";
this.copyright = " Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported";
this.contributors = "Code optimizations provided by PhantorGorth (Paul Cooper)";

// ********************* END-USER VARIABLES  *********************
// The variables in this section can be modified by the end user
// to alter behavior of this script.  The variables are explained
// below:
var deepHorizon_GGS_Verbose = true;  // Enables messages regarding refueling and
//  scooping altitudes to be passed to the player.
// ***************************************************************

// These variables are used in various functions within the system.
// ********************* DO NOT ALTER THESE  *********************
var deepHorizon_GGS_Refuel_Possible = false;
var deepHorizon_GGS_gasGiantIDs = new Array();
var deepHorizon_GGS_miningCount = 0;
var deepHorizon_GGS_refuelCounter = 0;
var deepHorizon_GGS_speedWarningCounter = 0;
var deepHorizon_GGS_minGasMiningAltMsgDelivered = false;
var deepHorizon_GGS_minRefuelingAltMsgDelivered = false;
this.systemHasGasGiants = false;
this.nearestGasGiant = null;
this.gasGiantsInRangeCount = 0;
this.gasGiantsInRange = new Array();
this.systemHasGasGiants = false;
this.systemDone = false;
// ***************************************************************

// ********************* DEBUGGING VARIABLES  *********************
// These variables are for debugging purposes only.  Some of them
// can cause significant decrease in system speed while enabled.  
// Enabling of these options is not recommended unless you are
// familiar with scripting.
this.dbg_GG_Skimmer_Script= false;
this.dbg_GG_Skimmer_Events = false;
this.dbg_Gas_Skimming = false;
this.dbg_Fuel_Skimming = false;
// ***************************************************************




// ********************* EVENT-DRIVEN FUNCTIONS  *********************
this.startUp = this.reset = function() {
	log("Initialising OXP " + this.name);
	if (!worldScripts["System Redux 2"]) player.commsMessage("It is highly recommended to utilize System Redux 2.0 in conjuction with Gas Giant Skimming.", 10);
	if (!worldScripts["oreProcessor"]) {
		player.commsMessage("Unable to load OXP: Gas Giant Skimming.  This oxp requires the Ore Processor OXP.", 10);
		delete this.shipLaunchedFromStation;
		delete this.shipWillExitWitchspace;
		delete this.shipExitedWitchspace;
		delete this.shipEnteredPlanetaryVicinity;
		delete this.shipExitedPlanetaryVicinity;
		delete this.shipDied;
		}
	this.RefuelingSound = new SoundSource;
	this.RefuelingSound.sound = "scoop.ogg";
	this.RefuelingSound.loop = true;
	this.systemDone = false;
}

this.shipLaunchedFromStation  =  function(station) {
	//if (this.dbg_GG_Skimmer_Script== true && this.dbg_GG_Skimmer_Events == true) log("[" + this.name + "]   Trigged by shipLaunchedFromStation.");
	if (!this.systemDone) this.buildGasGiantExtendedProperties();
	this.resetCounters();
	this.gasGiantCheck();
}

this.shipExitedWitchspace = function() {
	//if (this.dbg_GG_Skimmer_Script== true && this.dbg_GG_Skimmer_Events == true) log("[" + this.name + "]  Trigged by Exit from Witchspace.");
	this.resetCounters ();
	this.systemDone = false;
	this.buildGasGiantExtendedProperties ();
	this.gasGiantCheck();;
}

this.shipEnteredPlanetaryVicinity = function (planet) {
	//if (this.dbg_GG_Skimmer_Script== true && this.dbg_GG_Skimmer_Events == true) log("[" + this.name + "]  Trigged by shipEnteredPlanetaryVicinity");
	if (!planet.isGasGiant) return;
	this.nearestGasGiant = this.countGasGiantsInRange(system.planets);
	if (!this.refuelCheckTimer) {
		this.refuelCheckTimer = new Timer(this, this.GG_Scooping, 0, 0.65);
	}
}

this.shipExitedPlanetaryVicinity = function (planet) {
	//if (this.dbg_GG_Skimmer_Script== true && this.dbg_GG_Skimmer_Events == true) log("[" + this.name + "]  Trigged by shipExitedPlanetaryVicinity");
	if (planet == system.mainPlanet) {
		if (this.refuelCheckTimer) {
			this.RefuelingSound.stop();
			this.refuelCheckTimer.stop();
			delete this.refuelCheckTimer;
		}
	}
}

// Delete timers and stop sounds upon death of player.
this.shipDied = function(whom, why) {
	if (this.RefuelingSound.isPlaying) this.RefuelingSound.stop();
	if (this.refuelCheckTimer) {
		this.refuelCheckTimer.stop();
		delete this.refuelCheckTimer;
	}
}

this.equipmentDestroyed = this.equipmentDamanged = function (equipment) {
	if ((equipment == "EQ_FUEL_SCOOPS" || equipment == "EQ_GAS_REFINER") && this.refuelChecktimer) {
		this.refuelCheckTimer.stop();
		delete this.refuelCheckTimer;
	}
}

this.shipWillEnterWitchspace = function() {
	if (!system.isInterstellarSpace) this.shipExitedPlanetaryVicinity (system.mainPlanet);
}

// *******************************************************************

// ********************* OXP-SPECIFIC FUNCTIONS  *********************
this.resetCounters = function () {
	//if (this.dbg_GG_Skimmer_Script== true && this.dbg_GG_Skimmer_Events == true) log("[" + this.name + "]   Trigged by this.resetCounters.");
	this.gasGiantsInRangeCount = 0;
	deepHorizon_GGS_minGasMiningAltMsgDelivered = false;
	deepHorizon_GGS_minRefuelingAltMsgDelivered = false;
	deepHorizon_GGS_miningCount = 0;
	deepHorizon_GGS_speedWarningCounter = 0;
	deepHorizon_GGS_refuelCounter = 0;
}

this.gasGiantCheck = function () {
	//if (this.dbg_GG_Skimmer_Script== true && this.dbg_GG_Skimmer_Events == true) log("[" + this.name + "]   Trigged by this.gasGiantcheck.");
	this.systemHasGasGiants = this.getSystemGasGiants ();
	if (this.systemHasGasGiants) {
		this.nearestGasGiant = this.countGasGiantsInRange(system.planets);
		if (this.nearestGasGiant != null) this.shipEnteredPlanetaryVicinity (this.nearestGasGiant);
	}
}

this.buildGasGiantExtendedProperties = function () {
	//if (this.dbg_GG_Skimmer_Script== true && this.dbg_GG_Skimmer_Events == true) log("[" + this.name + "]   Trigged by this.buildGasGiantExtendedProperties.");
	for (var i = 0; i < system.planets.length; i++) {
		if (system.planets[i].isGasGiant) {
			system.planets[i].radiusSquared = system.planets[i].radius * system.planets[i].radius;
			system.planets[i].miningLuck = ((((System.ID+1) * 524288 + galaxyNumber * 65536 + player.ship.galaxyCoordinates.x  * 256 + player.ship.galaxyCoordinates.y  + i) * 18199 + 15733) % 100);
			system.planets[i].miningRadius = system.planets[i].radiusSquared * 1.1236;
			system.planets[i].refuelingRadius = system.planets[i].radiusSquared * 1.2321;
		}
	}
	this.systemDone = true;
}

this.getSystemGasGiants = function () {
	//if (this.dbg_GG_Skimmer_Script== true && this.dbg_GG_Skimmer_Events == true) log("[" + this.name + "]   Trigged by this.getSystemGasGiants.");
	var j = 0;
	for (var i = 0; i < system.planets.length; i++) {
		if (system.planets[i].isGasGiant) j++;
	}
	if (j > 0) return true;
	return false;
}

this.countGasGiantsInRange = function (planetArray) {
	//if (this.dbg_GG_Skimmer_Script== true && this.dbg_GG_Skimmer_Events == true) log("[" + this.name + "]   Trigged by this.countGasGiantsInRange.");
	var lowestRelativeAltitude = -1;
	var relativeAltitude;
	var nearestGasGiant = null;
	this.gasGiantsInRange = [];
	this.gasGiantsInRangeCount = 0;
	for (var i = 0; i < planetArray.length; i++) {
		relativeAltitude = player.ship.position.squaredDistanceTo(planetArray[i].position);
		if (planetArray[i].isGasGiant) {
			if (relativeAltitude < planetArray[i].radiusSquared * 9) {
				this.gasGiantsInRange.push(planetArray[i]);
				this.gasGiantsInRangeCount++
				if (lowestRelativeAltitude == -1 || relativeAltitude < lowestRelativeAltitude) {
					nearestGasGiant = planetArray[i];
					lowestRelativeAltitude = relativeAltitude;
				}
			}
		}
	}
	if (nearestGasGiant != null) return nearestGasGiant;
	return null;
}

this.GG_Scooping = function() {
	//if (this.dbg_GG_Skimmer_Script== true && this.dbg_GG_Skimmer_Events == true) log("[" + this.name + "]  Trigged by this.GG_Scooping");
	if (player.ship.equipmentStatus("EQ_FUEL_SCOOPS") == "EQUIPMENT_UNAVAILABLE" || player.ship.equipmentStatus("EQ_GAS_REFINER") == "EQUIPMENT_UNAVAILABLE") return;
	
	//if (this.dbg_GG_Skimmer_Script== true && this.dbg_GG_Skimmer_Events == true) log("[" + this.name + "]  Completed Equipment Check - Proceeding...");
	var tempArrayLocalGasGiants = this.gasGiantsInRange.slice(0);
	if (this.gasGiantsInRangeCount >= 2) this.nearestGasGiant = this.countGasGiantsInRange(tempArrayLocalGasGiants);//Build array of size this.gasGiantsInRangeCount of the local GG's.  Use these for repeated checks
	
	//if (this.dbg_GG_Skimmer_Script== true && this.dbg_GG_Skimmer_Events == true) log("[" + this.name + "]  Completed enumeration of Gas Giants near Player...");
	var playerAltitude = player.ship.position.squaredDistanceTo(this.nearestGasGiant);

	//if (this.dbg_GG_Skimmer_Script== true && this.dbg_GG_Skimmer_Events == true) log("[" + this.name + "]  Completed player altitude calculation...");
	var minScoopingSpeed = player.ship.speed / player.ship.maxSpeed;
	if (minScoopingSpeed >= 0.3) {
		//if (this.dbg_GG_Skimmer_Script== true && this.dbg_GG_Skimmer_Events == true) log("[" + this.name + "]  Completed minimum speed requirement check...");
		if (playerAltitude <= this.nearestGasGiant.refuelingRadius) {
			//if (this.dbg_GG_Skimmer_Script== true && this.dbg_GG_Skimmer_Events == true) log("[" + this.name + "]  Entering Refueling subfunction");
			if (deepHorizon_GGS_Verbose == true && deepHorizon_GGS_minRefuelingAltMsgDelivered == false) player.consoleMessage("Minimum atmospheric depth for refueling has been reached.", 5);
			deepHorizon_GGS_minRefuelingAltMsgDelivered = true;
			//if (this.dbg_GG_Skimmer_Script== true && this.dbg_Fuel_Skimming == true) log("[" + this.name + "]  Player Altitude is within refueling radius");
			if (player.ship.fuel < 7) {
				deepHorizon_GGS_refuelCounter += 1;
				this.RefuelingSound.play();
				if (deepHorizon_GGS_refuelCounter >= 5) {
					deepHorizon_GGS_refuelCounter = 0
					player.ship.fuel += 0.1;
				}
			}
			else if (this.RefuelingSound.isPlaying) this.RefuelingSound.stop();
		}
		//else if (this.dbg_GG_Skimmer_Script== true && this.dbg_GG_Skimmer_Events == true) log("[" + this.name + "]  Failed refueling radius check.");
		if (playerAltitude <= this.nearestGasGiant.miningRadius && player.ship.cargoSpaceAvailable > 0) {
			//if (this.dbg_GG_Skimmer_Script== true && this.dbg_Gas_Skimming == true) log("[" + this.name + "]  Entering Mining subfunction");
			if (deepHorizon_GGS_Verbose == true && deepHorizon_GGS_minGasMiningAltMsgDelivered == false) player.consoleMessage("Minimum atmospheric depth for gas mining has been attained.", 5);
			deepHorizon_GGS_minGasMiningAltMsgDelivered = true;
			//if (this.dbg_GG_Skimmer_Script== true && this.dbg_Gas_Skimming == true) log("[" + this.name + "]  Player Altitude is within mining radius");
			//if (this.dbg_GG_Skimmer_Script== true && this.dbg_Gas_Skimming == true) log("[" + this.name + "]  this.nearestGasGiant.miningLuck = " + this.nearestGasGiant.miningLuck + ".");
			if (this.nearestGasGiant.miningLuck < 49) {
				player.consoleMessage("Atmostpheric gases are being filtered and condensed...", 5);
				this.RefuelingSound.play();
				deepHorizon_GGS_miningCount += 1;
				if (deepHorizon_GGS_miningCount >= 60) {//Normally >= 60
					//if (this.dbg_GG_Skimmer_Script== true && this.dbg_Gas_Skimming == true) log("[" + this.name + "]  Entering Mining Results section");
					deepHorizon_GGS_miningCount = 0;
					var miningResults = Math.random();
					//if (this.dbg_GG_Skimmer_Script== true && this.dbg_Gas_Skimming == true) log("[" + this.name + "]  miningResults = " + miningResults + ".");
					if (miningResults < 0.7) { //70 - 100 = Nothing, Test at 1.0
						if (miningResults > 0.3) { //30-69 = Minerals
							if (0 < oolite.compareVersion("1.74")) player.ship.awardCargo("Minerals", 1);
							else player.ship.manifest.minerals +=1;
							player.consoleMessage("1 Ton minerals has been filtered and condenensed!", 5);
						}
						else if (miningResults > 0.15) { //16 - 29 Gems
							if (0 < oolite.compareVersion("1.74")) player.ship.awardCargo("gem-stones", 1);
							else player.ship.manifest.gemStones +=1;
							player.consoleMessage("1 gram micro-diamonds has been filtered!", 5);
						}
						else { //1-15 = Both Minerals and Gems
							if (0 < oolite.compareVersion("1.74")) {
								player.ship.awardCargo("Minerals", 1);
								player.ship.awardCargo("gem-stones", 1);
							}
							else {
								player.ship.manifest.minerals +=1;
								player.ship.manifest.gemStones +=1;
							}
							player.consoleMessage("Jackpot!  1 ton minerals and 1 gram micro-diamonds!", 5);
						}
					}
					else player.consoleMessage("Only worthless hydrogen gas scooped...", 5);
				}
			}
		}
		else {
			if (this.RefuelingSound.isPlaying) this.RefuelingSound.stop();
			//if (this.dbg_GG_Skimmer_Script== true && this.dbg_GG_Skimmer_Events == true) log("[" + this.name + "]  Failed mining radius check.");
		}
		
	}
	else {
		//if (this.dbg_GG_Skimmer_Script== true && this.dbg_GG_Skimmer_Events == true) log("[" + this.name + "]  Failed minimum speed requirement check...");
		deepHorizon_GGS_speedWarningCounter += 1
		if (deepHorizon_GGS_speedWarningCounter <= 1) player.consoleMessage("Skimming operations require at least 30% speed to function.", 5);
		if (deepHorizon_GGS_speedWarningCounter >= 240) deepHorizon_GGS_speedWarningCounter = 0;
	}
	//if (this.dbg_GG_Skimmer_Script== true && this.dbg_GG_Skimmer_Events == true) log("[" + this.name + "]  End of GG Scooping Function Reached");
}
// *******************************************************************